#include <string.h>
#include <Font.h>
#include <Looper.h>

#include "GetStringsMaxWidth.h"

float GetStringsMaxWidth(const char** Strings,int32 NumberOfStrings, const BFont* Font,
	float* StringWidths)
{
	int32* strlens = new int32[NumberOfStrings];
	int32 Counter;
	for(Counter = 0; Counter < NumberOfStrings; Counter++)
		strlens[Counter] = strlen(Strings[Counter]);
	bool ReleaseStringWidths;
	if(StringWidths)
		ReleaseStringWidths = false;
	else
	{
		StringWidths = new float[NumberOfStrings];
		ReleaseStringWidths = true;
	}
	Font->GetStringWidths(Strings,strlens,NumberOfStrings,StringWidths);
	float MaxWidth = StringWidths[0];
	for(Counter = 1; Counter < NumberOfStrings; Counter++)
		if(StringWidths[Counter] > MaxWidth)
			MaxWidth = StringWidths[Counter];
	if(ReleaseStringWidths)
		delete[] StringWidths;
	delete[] strlens;
	return MaxWidth;
}

